<?php
/**
* Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
* 
* RolePermission File
* PHP version 7
*
* @category  Library
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
namespace Solid_Backups\Strauss\Microsoft\Graph\Model;
/**
* RolePermission class
*
* @category  Model
* @package   Microsoft.Graph
* @copyright (c) Microsoft Corporation. All rights reserved.
* @license   https://opensource.org/licenses/MIT MIT License
* @link      https://graph.microsoft.com
*/
class RolePermission extends Entity
{

    /**
    * Gets the resourceActions
    * Resource Actions each containing a set of allowed and not allowed permissions.
    *
    * @return ResourceAction The resourceActions
    */
    public function getResourceActions()
    {
        if (array_key_exists("resourceActions", $this->_propDict)) {
            if (is_a($this->_propDict["resourceActions"], "Solid_Backups\Strauss\Microsoft\Graph\Model\ResourceAction")) {
                return $this->_propDict["resourceActions"];
            } else {
                $this->_propDict["resourceActions"] = new ResourceAction($this->_propDict["resourceActions"]);
                return $this->_propDict["resourceActions"];
            }
        }
        return null;
    }

    /**
    * Sets the resourceActions
    * Resource Actions each containing a set of allowed and not allowed permissions.
    *
    * @param ResourceAction $val The value to assign to the resourceActions
    *
    * @return RolePermission The RolePermission
    */
    public function setResourceActions($val)
    {
        $this->_propDict["resourceActions"] = $val;
         return $this;
    }
}
